n = int(input())
a = list(map(int, input().split()))

# Перетворюємо числа на рядки для зручності роботи з префіксами
a_str = list(map(str, a))

# Сортуємо числа за довжиною, потім лексикографічно
a_str.sort(key=lambda x: (len(x), x))

subsets = []

for num in a_str:
    placed = False
    for subset in subsets:
        # перевіряємо, чи num є префіксом будь-якого числа в subset
        if any(s.startswith(num) or num.startswith(s) for s in subset):
            subset.append(num)
            placed = True
            break
    if not placed:
        subsets.append([num])

# Вивід
print(len(subsets))
for subset in subsets:
    print(len(subset))
    print(" ".join(subset))
